/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.eclipse.formatjava;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICodeFormatter;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.klomp.eclipse.formatjava.FormatJavaPlugin;

public class FormatJavaOperation
implements IWorkspaceRunnable {
    private ICompilationUnit[] units;

    public FormatJavaOperation(ICompilationUnit[] units) {
        this.units = units;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("formatting", this.units.length);
        this.processJavaFiles(monitor);
        monitor.done();
    }

    private void processJavaFiles(IProgressMonitor monitor) throws CoreException {
        int i = 0;
        while (i < this.units.length) {
            ICompilationUnit cu = this.units[i];
            ICompilationUnit working = (ICompilationUnit)cu.findSharedWorkingCopy(JavaUI.getBufferFactory());
            if (working != null) {
                cu = working;
            }
            boolean unsavedChanges = cu.hasUnsavedChanges();
            monitor.subTask(this.units[i].getPath().toString());
            this.processJavaFile(monitor, cu, !unsavedChanges);
            monitor.worked(1);
            ++i;
        }
    }

    private void processJavaFile(IProgressMonitor monitor, ICompilationUnit cu, boolean save) throws CoreException {
        ICompilationUnit orig = cu;
        if (cu.isWorkingCopy()) {
            orig = (ICompilationUnit)cu.getOriginalElement();
        }
        IFile file = (IFile)orig.getUnderlyingResource();
        final IDocumentProvider docProvider = JavaUI.getDocumentProvider();
        FileEditorInput input = new FileEditorInput(file);
        docProvider.connect((Object)input);
        try {
            final IDocument document = docProvider.getDocument((Object)input);
            IAnnotationModel annotationModel = docProvider.getAnnotationModel((Object)input);
            annotationModel.connect(document);
            try {
                IWorkspaceRunnable action = new IWorkspaceRunnable((IFileEditorInput)input, save){
                    private final /* synthetic */ IFileEditorInput val$input;
                    private final /* synthetic */ boolean val$save;
                    {
                        this.val$input = iFileEditorInput;
                        this.val$save = bl;
                    }

                    public void run(IProgressMonitor monitor) throws CoreException {
                        block5: {
                            try {
                                int length = document.getLength();
                                String source = document.get(0, length);
                                String formatted = FormatJavaOperation.formatJava(source);
                                if (formatted.equals(source)) break block5;
                                document.replace(0, length, formatted);
                                docProvider.aboutToChange((Object)this.val$input);
                                try {
                                    if (this.val$save || docProvider.mustSaveDocument((Object)this.val$input)) {
                                        docProvider.saveDocument(monitor, (Object)this.val$input, document, true);
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object var5_7 = null;
                                    docProvider.changed((Object)this.val$input);
                                    throw throwable;
                                }
                                Object var5_8 = null;
                                docProvider.changed((Object)this.val$input);
                            }
                            catch (BadLocationException exc) {
                                FormatJavaPlugin.getDefault().throwCoreException("cannot.replace.contents", exc);
                            }
                        }
                    }
                };
                ResourcesPlugin.getWorkspace().run(action, monitor);
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                annotationModel.disconnect(document);
                throw throwable;
            }
            Object var11_13 = null;
            annotationModel.disconnect(document);
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            docProvider.disconnect((Object)input);
            throw throwable;
        }
        Object var13_16 = null;
        docProvider.disconnect((Object)input);
    }

    private static String formatJava(String source) {
        ICodeFormatter formatter = ToolFactory.createCodeFormatter();
        return formatter.format(source, 0, null, null);
    }
}

