/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.eclipse.formatjava;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.klomp.eclipse.formatjava.FormatJavaOperation;
import org.klomp.eclipse.formatjava.FormatJavaPlugin;

public class FormatJavaAction
implements IObjectActionDelegate {
    private IWorkbenchPart part;
    private IStructuredSelection selection;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.part = targetPart;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection instanceof IStructuredSelection ? (IStructuredSelection)selection : null;
    }

    public void run(IAction action) {
        Shell shell = this.part.getSite().getShell();
        try {
            this.perform(shell);
        }
        catch (CoreException exc) {
            FormatJavaPlugin.getDefault().reportException(shell, "error.while.processing", exc);
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        catch (RuntimeException exc) {
            FormatJavaPlugin.getDefault().reportException(shell, "error.while.processing", exc);
        }
    }

    private void perform(Shell shell) throws CoreException {
        if (this.selection == null) {
            return;
        }
        final ICompilationUnit[] units = FormatJavaAction.expandSelection((ISelection)this.selection);
        if (units.length == 0) {
            return;
        }
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
        try {
            dialog.run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)new FormatJavaOperation(units), monitor);
                    }
                    catch (OperationCanceledException e) {
                        throw new InterruptedException(e.getMessage());
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InvocationTargetException exc) {
            Throwable targetException = exc.getTargetException();
            if (targetException instanceof CoreException) {
                throw (CoreException)targetException;
            }
            FormatJavaPlugin.getDefault().throwCoreException("error.while.processing", targetException);
        }
        catch (InterruptedException interruptedException) {}
    }

    private static ICompilationUnit[] expandSelection(ISelection selection) throws CoreException {
        if (!(selection instanceof IStructuredSelection)) {
            return new ICompilationUnit[0];
        }
        IStructuredSelection ss = (IStructuredSelection)selection;
        ArrayList result = new ArrayList();
        FormatJavaAction.expandObjects(ss.toArray(), result);
        return result.toArray(new ICompilationUnit[result.size()]);
    }

    private static void expandObjects(Object[] objects, Collection result) throws CoreException {
        int i = 0;
        while (i < objects.length) {
            Object o = objects[i];
            if (o instanceof ICompilationUnit) {
                result.add(o);
            } else if (o instanceof IPackageFragment) {
                IPackageFragment pack = (IPackageFragment)o;
                result.addAll(Arrays.asList(pack.getCompilationUnits()));
            } else if (o instanceof IPackageFragmentRoot) {
                IPackageFragmentRoot fragRoot = (IPackageFragmentRoot)o;
                FormatJavaAction.expandObjects(fragRoot.getChildren(), result);
            }
            ++i;
        }
    }
}

